/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource;

import java.util.Enumeration;
import jclass.datasource.BaseDataTable;
import jclass.datasource.BaseMetaData;
import jclass.datasource.DataModel;
import jclass.datasource.DataModelAdapter;
import jclass.datasource.DataModelEvent;
import jclass.datasource.DataModelException;
import jclass.datasource.DataModelListener;
import jclass.datasource.DataTableModel;
import jclass.datasource.IdeDataTableModel;
import jclass.datasource.IdeMetaDataModel;
import jclass.datasource.LocaleBundle;
import jclass.datasource.MetaDataModel;
import jclass.datasource.treemodel.TreeNodeModel;

public abstract class IdeMetaData
extends BaseMetaData
implements IdeMetaDataModel {
    public static long globalBookmarkBeforeLastMove = -1L;
    public static DataTableModel globalDataTableBeforeLastMove = null;

    public IdeMetaData(DataModel dataModel) {
        super(dataModel);
    }

    public void navigated(int n) {
        if (!this.getDataModel().getEventsEnabled()) {
            return;
        }
        globalBookmarkBeforeLastMove = this.getDataModel().getCurrentGlobalBookmark();
        globalDataTableBeforeLastMove = this.getDataModel().getCurrentGlobalTable();
        try {
            MetaDataModel metaDataModel = (MetaDataModel)this.getParent();
            DataTableModel dataTableModel = null;
            if (metaDataModel == null) {
                dataTableModel = (DataTableModel)((Object)this.getDataModel().getDataTableTree().getRoot());
            } else {
                DataTableModel dataTableModel2 = metaDataModel.getCurrentDataTable();
                if (dataTableModel2 != null) {
                    dataTableModel = dataTableModel2.getTable(metaDataModel.getCurrentBookmark(), this);
                }
            }
            if (dataTableModel == null) {
                return;
            }
            long l = dataTableModel.getRowIdentifier(n);
            this.setCurrentBookmark(l);
            this.setCurrentDataTable(dataTableModel);
            if (dataTableModel.getMetaData().getDataModel().getCurrentGlobalBookmark() != l || this.getCurrentBookmark() != l) {
                this.getDataModel().moveToRow((DataModelListener)((Object)dataTableModel), dataTableModel, l, false);
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("navigated: " + exception.toString());
            return;
        }
    }

    public void requeryCurrentRowAndBelow(DataModelListener dataModelListener, DataTableModel dataTableModel) {
        try {
            if (dataTableModel == null) {
                return;
            }
            long l = dataTableModel.getParentBookmark();
            MetaDataModel metaDataModel = (MetaDataModel)dataTableModel.getMetaData().getParent();
            DataTableModel dataTableModel2 = null;
            int n = 109;
            if (metaDataModel == null) {
                dataTableModel2 = dataTableModel;
                n = 103;
            } else {
                dataTableModel2 = this.getDataModel().getCurrentDataTable(dataModelListener, metaDataModel);
            }
            if (dataTableModel2 != null) {
                if (n == 103) {
                    ((IdeDataTableModel)dataTableModel2).requeryFromIdeDataSource();
                    this.getDataModel().clearCurrentPath(this);
                    this.setCurrentBookmark(-1L);
                } else {
                    ((TreeNodeModel)((Object)dataTableModel)).setParent(null);
                    this.getDataModel().clearCurrentPath(metaDataModel);
                    dataTableModel2.deleteCacheChildren(dataModelListener);
                }
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this.getDataModel(), dataModelListener, dataTableModel2, l, "", n);
            this.getDataModel().fireDataModelEvent(dataModelEvent);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
    }

    public void handleIDEUpdateCellRequest(IdeDataTableModel ideDataTableModel, long l) {
        Object object;
        Object object2;
        try {
            String string = null;
            int n = 0;
            while (n < this.getColumnCount()) {
                object2 = this.getColumnIdentifier(n);
                object = ideDataTableModel.getCell2(l, (String)object2);
                Object object3 = ideDataTableModel.getResultData(l, this.getColumnIdentifier(n));
                if (object == null && object3 != null || object3 == null && object != null || object3 != null && object != null && !object.equals(object3)) {
                    string = object2;
                    break;
                }
                ++n;
            }
            if (string == null) {
                string = this.getColumnIdentifier(this.getColumnCount() - 1);
            }
            if (!((BaseDataTable)((Object)ideDataTableModel)).prepareCellUpdate((DataModelListener)((Object)ideDataTableModel), l, string)) {
                return;
            }
            ((BaseDataTable)((Object)ideDataTableModel)).setRowDirty(l);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
        this.turnOffDataModelEvents();
        try {
            int n = 0;
            while (n < this.getColumnCount()) {
                String string = this.getColumnIdentifier(n);
                object2 = ideDataTableModel.getCell2(l, string);
                object = ideDataTableModel.getResultData(l, this.getColumnIdentifier(n));
                if (object2 == null && object != null || object == null && object2 != null || object != null && object2 != null && !object2.equals(object)) {
                    ideDataTableModel.setValueAt2(l, string, object2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            try {
                DataModelEvent dataModelEvent = new DataModelEvent(this.getDataModel(), (DataModelListener)((Object)ideDataTableModel), ideDataTableModel, l, "", 100);
                this.getDataModel().fireDataModelEvent(dataModelEvent);
            }
            catch (DataModelException dataModelException) {}
        }
        this.turnOnDataModelEvents();
        try {
            DataModelEvent dataModelEvent = new DataModelEvent(this.getDataModel(), (DataModelListener)((Object)ideDataTableModel), ideDataTableModel, l, "", 100);
            this.getDataModel().fireDataModelEvent(dataModelEvent);
            return;
        }
        catch (DataModelException dataModelException) {
            return;
        }
    }

    public void turnOffDataModelEvents() {
        this.getDataModel().enableDataModelEvents(false);
    }

    public void turnOnDataModelEvents() {
        this.getDataModel().enableDataModelEvents(true);
    }

    public void cleanChildDataSets() throws Exception {
        Enumeration enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            this.cleanChildDataSets((IdeMetaData)enumeration.nextElement());
        }
    }

    protected void cleanChildDataSets(IdeMetaData ideMetaData) throws Exception {
        ideMetaData.refreshDataSet();
        Enumeration enumeration = ideMetaData.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            this.cleanChildDataSets((IdeMetaData)enumeration.nextElement());
        }
    }

    public void setCommitPolicy(int n) throws DataModelException {
        if (n != 1) {
            Exception exception = new Exception(LocaleBundle.string("Only COMMIT_LEAVING_RECORD is currently supported in ide environments"));
            throw new DataModelException(107, exception);
        }
        super.setCommitPolicy(n);
    }

    protected boolean handledAsSingleLevelBindingMove() throws Exception {
        try {
            TreeNodeModel treeNodeModel = this.getDataModel().getMetaDataTree().getRoot();
            if (!treeNodeModel.hasChildren()) {
                this.turnOffDataModelEvents();
                this.getDataModel().requeryAll(new DataModelAdapter());
                this.turnOnDataModelEvents();
                return true;
            }
        }
        catch (Exception exception) {
            this.turnOnDataModelEvents();
        }
        return false;
    }

    public abstract void refreshDataSet() throws Exception;
}

